#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

void bsort(int *, int);
int pow_i(int, int);

int main()
{
    int N, Q;

    scanf("%d%d", &N, &Q);

    if (N < 1 || N > 2 * pow_i(10, 5) || Q < 1 || Q > 2 * pow_i(10, 5)) return 0;

    int *A = malloc(N * sizeof(int));
    int *B = malloc(Q * sizeof(int));
    int *C = malloc(N * sizeof(int));

    for (int i = 0; i < N; i++) {
        scanf("%d", &A[i]);

        if (A[i] < 0 || A[i] > pow_i(10, 9)) return 0;
    }

    bsort(A, N);

    for (int i = 0; i < Q; i++) {
        scanf("%d", &B[i]);

        if (B[i] < 0 || B[i] > pow_i(10, 9)) return 0;
    }

    for (int i = 0; i < N; i++)
        C[i] = A[i];

    for (int i = 0; i < Q; i++)
    {   
        if (i != 0)
            putchar('\n');

        if (A[N / 2] == B[i]) {
            printf("0");
            continue;
        }
        
        int Nc = N;

        do
        {
            Nc++;
            C = realloc(C, Nc * sizeof(int));
            C[Nc - 1] = B[i];
            bsort(C, Nc);
        } while (C[Nc / 2] != B[i]);

        printf("%d", Nc - N);

        C = realloc(C, N * sizeof(int));
    }
}

void bsort(int *arr, int n)
{
    bool zamena = true;

    while (zamena)
    {
        zamena = false;

        for (int i = 0, tmp; i < n - 1; i++)
        {
            if (arr[i] > arr[i + 1])
            {
                zamena = true;

                tmp = arr[i];
                arr[i] = arr[i + 1];
                arr[i + 1] = tmp;
            }
        }
    }
}

int pow_i(int base, int exp)
{
    if (exp == 0)
        return 1;

    int tmp = base;

    while (--exp)
        base *= tmp;

    return base;
}